package cz.muni.fi.pb162.test.concentration;



/**
 * The test class ConcentrationTest.
 *
 * @author  (your name)
 * @version (a version number or a date)
 */
public class ConcentrationTest extends junit.framework.TestCase
{
    private ConcentrationDesk desk;
    
    private Card[] cards = new Card[] {
        new Card("Red","Tree"),
        new Card("Blue","Dog"),
        new Card("Red","Tree"),
        new Card("Blue","Dog")
    };
    
    /**
     * Default constructor for test class ConcentrationTest
     */
    public ConcentrationTest()
    {
    }

    /**
     * Sets up the test fixture.
     *
     * Called before every test case method.
     */
    protected void setUp()
    {
        try {
            desk = new ConcentrationDeskImpl(cards);
        } catch(Exception ex) {
            fail("Konstruktor se spravnym polem karet vyhodil vyjimku: " + ex);
        }
    }
    
    public void testCard() {
        Card c1 = new Card(new String("aaa"), new String("bbb"));
        Card c2 = new Card(new String("aaa"), new String("bbb"));
        Card c3 = new Card(new String("AAA"), new String("bbb"));
        Card c4 = new Card(new String("aaa"), new String("BBB"));
        assertTrue("Chybna implementace tridy Card", c1.equals(c1));
        assertTrue("Chybna implementace tridy Card", c1.equals(c2));
        assertTrue("Chybna implementace tridy Card", c2.equals(c1));
        assertFalse("Chybna implementace tridy Card", c1.equals(c3));
        assertFalse("Chybna implementace tridy Card", c1.equals(c4));
        assertTrue("Chybna implementace tridy Card", c1.hashCode() == c2.hashCode());
    }
    
    public void testConstructor() {
        try {
            new ConcentrationDeskImpl(null);
            fail("Konstruktor nevyhodil vyjimku pro null pole");
        } catch (IllegalCardSetException ex) {
            // ok
        } catch (Exception ex) {
            fail("Konstruktor pro null pole vyhodil spatnou vyjimku: " + ex);
        }
        
        try {
            new ConcentrationDeskImpl(new Card[] {new Card("",""), null, new Card("",""), null});
            fail("Konstruktor nevyhodil vyjimku pro pole s null prvkem");
        } catch (IllegalCardSetException ex) {
            // ok
        } catch (Exception ex) {
            fail("Konstruktor pro pole s null prvkem vyhodil spatnou vyjimku: " + ex);
        }
        
        try {
            new ConcentrationDeskImpl(new Card[] {new Card("","")});
            fail("Konstruktor nevyhodil vyjimku pro pole s jednou kartou");
        } catch (IllegalCardSetException ex) {
            // ok
        } catch (Exception ex) {
            fail("Konstruktor pro pole s jednou kartou vyhodil spatnou vyjimku: " + ex);
        }
        
        try {
            new ConcentrationDeskImpl(new Card[] {new Card("",""), new Card("",""), new Card("","")});
            fail("Konstruktor nevyhodil vyjimku pro pole se tremi stejnymi kartami");
        } catch (IllegalCardSetException ex) {
            // ok
        } catch (Exception ex) {
            fail("Konstruktor pro pole se tremi stejnymi kartami vyhodil spatnou vyjimku: " + ex);
        }
        
        try {
            new ConcentrationDeskImpl(new Card[] {new Card("aaa","bbb"), new Card("bbb","aaa")});
            fail("Konstruktor nevyhodil vyjimku pro pole se dvema ruznymi kartami");
        } catch (IllegalCardSetException ex) {
            // ok
        } catch (Exception ex) {
            fail("Konstruktor pro pole se dvema ruznymi kartami vyhodil spatnou vyjimku: " + ex);
        }
        
        try {
            new ConcentrationDeskImpl(new Card[] {new Card("aaa","bbb"), new Card("aaa","bbb")});
        } catch (Exception ex) {
            fail("Konstruktor se spravnym polem karet vyhodil vyjimku: " + ex);
        }
    }
    
    public void testGame() {
        try {
            desk.uncoverSecondCard(1);
            fail("Pri pokusu o otoceni druhe karty nebyla vyhozena vyjimka");
        } catch(IllegalOperationException ex) {
            // ok
        } catch(Exception ex) {
            fail("Pri pokusu o otoceni druhe karty byla vyhozena spatna vyjimka " + ex);
        }
        
        try {
            desk.uncoverFirstCard(-1);
            desk.uncoverFirstCard(4);
            fail("Otoceni prvni karty mimo rozsah nevyhodilo vyjimku");
        } catch(NoCardException ex) {
            // ok
        } catch(Exception ex) {
            fail("Otoceni prvni karty mimo rozsah vyhodilo spatnou vyjimku " + ex);
        }
        
        try {
            assertEquals("Otoceni prvni karty vratilo chybnou kartu", cards[1], desk.uncoverFirstCard(1));
        } catch (Exception ex) {
            fail("Otoceni prvni karty vyhodilo neocekavanou vyjimku: " + ex);
        }
        
        try {
            desk.uncoverFirstCard(2);
            fail("Otoceni prvni karty nevyhodilo vyjimku");
        } catch(IllegalOperationException ex) {
            // ok
        } catch(Exception ex) {
            fail("Otoceni prvni karty vyhodilo spatnou vyjimku " + ex);
        }
        
        try {
            desk.uncoverSecondCard(-1);
            desk.uncoverSecondCard(4);
            fail("Otoceni druhe karty mimo rozsah nevyhodilo vyjimku");
        } catch(NoCardException ex) {
            // ok
        } catch(Exception ex) {
            fail("Otoceni druhe karty mimo rozsah vyhodilo spatnou vyjimku " + ex);
        }

        try {
            desk.uncoverSecondCard(1);
            fail("Otoceni jiz otocene karty nevyhodilo vyjimku");
        } catch(UncoveredCardException ex) {
            // ok
        } catch(Exception ex) {
            fail("Otoceni jiz otocene karty vyhodilo spatnou vyjimku " + ex);
        }
        
        try {
            assertFalse("Otoceni druhe neparove karty vratilo true", desk.uncoverSecondCard(2));
        } catch (Exception ex) {
            fail("Otoceni druhe neparove karty vyhodilo neocekavanou vyjimku: " + ex);
        }

        try {
            desk.uncoverFirstCard(1);
        } catch (NoCardException ex) {
            fail("Otoceni neparove druhe karty pravdepodobne smazalo prvni kartu");
        } catch (Exception ex) {
            fail("Otoceni prvni karty vyhodilo neocekavanou vyjimku: " + ex);
        }
        
        try {
            assertTrue("Otoceni druhe parove karty vratilo false", desk.uncoverSecondCard(3));
        } catch (Exception ex) {
            fail("Otoceni druhe parove karty vyhodilo neocekavanou vyjimku: " + ex);
        }
        
        try {
            desk.uncoverFirstCard(1);
            fail("Nalezeni shodneho paru neodebralo prvni kartu");
        } catch (NoCardException ex) {
            // ok
        } catch (Exception ex) {
            fail("Neocekavana vyjimka: " + ex);
        }        
    }

    /**
     * Tears down the test fixture.
     *
     * Called after every test case method.
     */
    protected void tearDown()
    {
    }
}
