package cz.muni.fi.pb162.test.concentration;

import java.util.Arrays;

/**
 * Simple demo that demonstrates Concentration game.
 *
 * <p>Created 28.11.2009 at 18:46:57.
 *
 * @author Rastislav Mirek <rmirek at mail.muni.cz>
 * @version %I%, %G%
 */
public class Demo {

    public static final int CELL_WIDTH = 10;
    public static final int DIMENSION = 2;

    /**
     * Runs demontration.
     * @param args command line arguments
     */
    public static void main(String[] args) throws ConcentrationException{
        ConcentrationDesk game = new ConcentrationDeskImpl(new Card[] {
            new Card("Blue", "Dog"),
            new Card("Red", "Tree"), 
            new Card("Blue", "Dog"),
            new Card("Red", "Tree")
        });
        
        printGamePlane(game, 4);
        
        game.uncoverFirstCard(1);
        game.uncoverSecondCard(2);    
        printGamePlane(game, 4);
        
        game.uncoverFirstCard(1);
        game.uncoverSecondCard(3);
        printGamePlane(game, 4);
            
        game.uncoverFirstCard(0);
        game.uncoverSecondCard(2);
        printGamePlane(game, 4);
    }

    /**
     * Prints game plane of given {@code ConcentrationDesk} to standard output.
     * @param game Desk to print
     * @param cards Initial number of cards in the game
     */
    public static void printGamePlane(ConcentrationDesk game, int cards){
        for(int i = 0; i < cards; i++) printCard(game.cardAt(i));
        System.out.println();
        //System.out.println("---");
    }

    /**
     * Prints card's text representation with aditional spaces to standard output.
     * @param card Card to by printed
     */
    public static void printCard(Card card){
        int length = (card == null) ? 4 : card.toString().length();
        char[] spaces = new char[length > CELL_WIDTH? 0: CELL_WIDTH - length];
        Arrays.fill(spaces, ' ');
        System.out.print(card + new String(spaces));
    }
}
