package cz.muni.fi.pb162.test.concentration;


/**
 * Contract of the ConcetrationDesk interface specifies that the 
 * uncoverFirstCard() and uncoverSecondCard() methods have to be 
 * invoked in turns and in this order. 
 * This exception is supposed to be thrown when this contract is 
 * violated, e.g. if someone attempts to uncover first card twice.
 *
 * <p>Created 2.12.2009 at 20:23:33.
 *
 * @author Radek Oslejsek <oslejsek at mail.muni.cz>
 * @version %I%, %G%
 */
public class IllegalOperationException extends ConcentrationException
{
    public IllegalOperationException() {
    }

    public IllegalOperationException(String message) {
        super(message);
    }

    public IllegalOperationException(String message, Throwable cause) {
        super(message, cause);
    }

    public IllegalOperationException(Throwable cause) {
        super(cause);
    }

}

